package mcfall.raytracer.objects;

import java.util.List;

import mcfall.math.IncompatibleMatrixException;
import mcfall.math.Point;
import mcfall.math.Ray;
import mcfall.math.Vector;
//TODO create hittime
public class PointTriangle extends GenericPlane {
	protected Point p1, p2, p3;
	private final Vector normalVector;
	public PointTriangle(Point p1, Point p2, Point p3) {
		super();
		this.p1=p1;this.p3=p2;this.p3=p3;
		Vector r1 = p2.subtract(p1);
		Vector r2 = p3.subtract(p1);
		try {
			normalVector = r1.cross(r2).normalize();
			forcePlaneToPointNormal(p1,normalVector);
		} catch (IncompatibleMatrixException e) {
			e.printStackTrace();
			throw new RuntimeException();
		}
	}
	//TODO test me!!!
	@Override
	protected List<HitRecord> genericHitTime(Ray ray) {
		List<HitRecord> hits = super.genericHitTime(ray);
		for(HitRecord hit : hits) {//useless abstraction since GenericPlanes have <=1 hit but it eliminates using get(0)
			Point p = ray.pointAt(hit.hitTime);
			Vector normal = hit.normal.normalize();
			try {
				//use barycentric coords to figure out if we actually hit the triangle
				//This creates new trangles from each side of the existing triangle to the point
				//if the areas add up to be equal to the initial traingle then the point is inside else its not 
				//see http://www.devmaster.net/articles/raytracing/
				double t = p2.subtract(p3).cross(p.subtract(p1)).dot(normal);
				double s = p.subtract(p1).cross(p3.subtract(p1)).dot(normal);
				double r = 1-(s+t);
				if(r+s+t==1d) {
					return hits;
				}
			} catch (IncompatibleMatrixException e) {
				throw new RuntimeException();
			}
		}
		return null;
	}

}
